#!/bin/sh

RAZER_VENDOR="1532"
RAZER_PRODUCT="0116"

DRIVER_KBD="razer_kbd"
DRIVER_TP="razer_tp"

bind_interface () {
    INTERFACE=$1
    DRIVER=$2

    [ -f $INTERFACE/driver/unbind ] && echo -n "$INTERFACE" > $INTERFACE/driver/unbind
    echo -n "$INTERFACE" > /sys/bus/usb/drivers/$DRIVER/bind
}

if [ "$1" = "0" ]
then
    DRIVER_KBD="usbhid"
    DRIVER_TP="usbhid"
fi

[ -d /sys/bus/usb/drivers/$DRIVER_KBD -a -d /sys/bus/usb/drivers/$DRIVER_TP ] || exit 2

cd /sys/bus/usb/devices/
for DEVICE in *
do
    if [ -f $DEVICE/idVendor ]
    then
        VENDOR=$(cat $DEVICE/idVendor) 
        PRODUCT=$(cat $DEVICE/idProduct) 
        if [ $VENDOR = $RAZER_VENDOR -a $PRODUCT = $RAZER_PRODUCT ]
        then
            RAZER_DEVICE=$DEVICE
            break;
        fi
    fi
done

[ -z $RAZER_DEVICE ] && exit 19

echo "USB device $RAZER_DEVICE"

cd $RAZER_DEVICE

for INTERFACE in $RAZER_DEVICE*
do
    PROTOCOL=$(<$INTERFACE/bInterfaceProtocol)
    
    case $PROTOCOL in
    "00")
        INTERFACE_NUM=$(<$INTERFACE/bInterfaceNumber)
        INTERFACE_ALT=$(<$INTERFACE/bAlternateSetting)

        if [ $INTERFACE_NUM -eq 0 -a $INTERFACE_ALT -eq 1 ] 
        then
            echo "Binding touchpad interface (alt) $INTERFACE to $DRIVER_TP"
            bind_interface $INTERFACE $DRIVER_TP
        fi
        ;;
    "01")
        echo "Binding keyboard interface $INTERFACE to $DRIVER_KBD"
        bind_interface $INTERFACE $DRIVER_KBD
        ;;
    "02")
        echo "Binding touchpad interface $INTERFACE to $DRIVER_KBD"
        bind_interface $INTERFACE $DRIVER_TP
        ;;
    esac
done

