#!/bin/sh

[ -z "$DEVPATH"] && exit 22

DEVICE_DIR="/sys$DEVPATH"

[ -d $DEVICE_DIR ] || exit 2

INTERFACE=$(basename $DEVPATH)
DRIVER_KBD="razer_kbd"
DRIVER_TP="razer_tp"

cd $DEVICE_DIR

PROTOCOL=$(<bInterfaceProtocol)

case $PROTOCOL in
"01")
    [ -d /sys/bus/usb/drivers/$DRIVER_KBD ] || exit 2
    [ -f driver/unbind ] && echo -n "$INTERFACE" > driver/unbind
    echo -n "$INTERFACE" > /sys/bus/usb/drivers/$DRIVER_KBD/bind
    ;;
"02")
    [ -d /sys/bus/usb/drivers/$DRIVER_TP ] || exit 2
    [ -f driver/unbind ] && echo -n "$INTERFACE" > driver/unbind
    echo -n "$INTERFACE" > /sys/bus/usb/drivers/$DRIVER_TP/bind
    ;;
esac

